package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Lite version of {@link ru.yandex.intranet.d.services.integration.providers.rest.model.ProvisionDto ProvisionDto}.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 24-12-2020
 */
@Schema(description = "Provision.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvisionLiteDto {
    private final String resourceId;
    private final String providedAmount;
    private final String providedAmountUnitId;
    private final String oldProvidedAmount;
    private final String oldProvidedAmountUnitId;

    @JsonCreator
    public ProvisionLiteDto(
            String resourceId,
            String providedAmount,
            String providedAmountUnitId,
            String oldProvidedAmount,
            String oldProvidedAmountUnitId
    ) {
        this.resourceId = resourceId;
        this.providedAmount = providedAmount;
        this.providedAmountUnitId = providedAmountUnitId;
        this.oldProvidedAmount = oldProvidedAmount;
        this.oldProvidedAmountUnitId = oldProvidedAmountUnitId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Provided amount.", required = true)
    public Optional<String> getProvidedAmount() {
        return Optional.ofNullable(providedAmount);
    }

    @Schema(description = "Provided amount unit ID.", required = true)
    public Optional<String> getProvidedAmountUnitId() {
        return Optional.ofNullable(providedAmountUnitId);
    }

    @Schema(description = "Old provided amount, for consistency check.", required = true)
    public Optional<String> getOldProvidedAmount() {
        return Optional.ofNullable(oldProvidedAmount);
    }

    @Schema(description = "Old provided amount unit ID.", required = true)
    public Optional<String> getOldProvidedAmountUnitId() {
        return Optional.ofNullable(oldProvidedAmountUnitId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionLiteDto that = (ProvisionLiteDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(providedAmount, that.providedAmount) &&
                Objects.equals(providedAmountUnitId, that.providedAmountUnitId) &&
                Objects.equals(oldProvidedAmount, that.oldProvidedAmount) &&
                Objects.equals(oldProvidedAmountUnitId, that.oldProvidedAmountUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, providedAmount, providedAmountUnitId, oldProvidedAmount,
                oldProvidedAmountUnitId);
    }

    @Override
    public String toString() {
        return "ProvisionLiteDto{" +
                "resourceId='" + resourceId + '\'' +
                ", providedAmount='" + providedAmount + '\'' +
                ", providedAmountUnitId='" + providedAmountUnitId + '\'' +
                ", oldProvidedAmount='" + oldProvidedAmount + '\'' +
                ", oldProvidedAmountUnitId='" + oldProvidedAmountUnitId + '\'' +
                '}';
    }

    public static final class Builder {

        private String resourceId;
        private String providedAmount;
        private String providedAmountUnitId;
        private String oldProvidedAmount;
        private String oldProvidedAmountUnitId;

        private Builder() {
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder providedAmount(String providedAmount) {
            this.providedAmount = providedAmount;
            return this;
        }

        public Builder providedAmountUnitId(String providedAmountUnitId) {
            this.providedAmountUnitId = providedAmountUnitId;
            return this;
        }

        public Builder oldProvidedAmount(String oldProvidedAmount) {
            this.oldProvidedAmount = oldProvidedAmount;
            return this;
        }

        public Builder oldProvidedAmountUnitId(String oldProvidedAmountUnitId) {
            this.oldProvidedAmountUnitId = oldProvidedAmountUnitId;
            return this;
        }

        public ProvisionLiteDto build() {
            return new ProvisionLiteDto(resourceId, providedAmount, providedAmountUnitId, oldProvidedAmount,
                    oldProvidedAmountUnitId);
        }

    }

}
