package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Add calculated {@link BigInteger} to {@link ProvisionLiteDto}.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 9-12-2020
 */
@Schema(description = "Provision.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProvisionLiteWithBigIntegers extends ProvisionLiteDto {
    private final BigInteger oldProvidedAmountBI;
    private final BigInteger providedAmountBI;

    public ProvisionLiteWithBigIntegers(ProvisionLiteDto provisionLiteDto, BigInteger oldProvidedAmountBI,
                                        BigInteger providedAmountBI) {
        super(provisionLiteDto.getResourceId().orElse(null),
                provisionLiteDto.getProvidedAmount().orElse(null),
                provisionLiteDto.getProvidedAmountUnitId().orElse(null),
                provisionLiteDto.getOldProvidedAmount().orElse(null),
                provisionLiteDto.getOldProvidedAmountUnitId().orElse(null));

        this.oldProvidedAmountBI = oldProvidedAmountBI;
        this.providedAmountBI = providedAmountBI;
    }

    @Schema(description = "Provided amount.", required = true)
    public Optional<BigInteger> getOldProvidedAmountBI() {
        return Optional.ofNullable(oldProvidedAmountBI);
    }

    @Schema(description = "Old provided amount, for consistency check.", required = true)
    public BigInteger getProvidedAmountBI() {
        return providedAmountBI;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProvisionLiteWithBigIntegers that = (ProvisionLiteWithBigIntegers) o;
        return Objects.equals(oldProvidedAmountBI, that.oldProvidedAmountBI) &&
                Objects.equals(providedAmountBI, that.providedAmountBI);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), oldProvidedAmountBI, providedAmountBI);
    }

    @Override
    public String toString() {
        return "ProvisionLiteWithBigIntegers{" +
                "oldProvidedAmountBI=" + oldProvidedAmountBI +
                ", providedAmountBI=" + providedAmountBI +
                "} " + super.toString();
    }
}
