package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quota set DTO
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Schema(description = "Quota set DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QuotaSetDto {
    private final Status status;
    private final long quotaChangeCount;

    @JsonCreator
    private QuotaSetDto(Status status, long quotaChangeCount) {
        this.status = status;
        this.quotaChangeCount = quotaChangeCount;
    }

    @Schema(description = "Status", required = true)
    public Status getStatus() {
        return status;
    }

    @Schema(description = "Count of changed quota", required = true)
    public long getQuotaChangeCount() {
        return quotaChangeCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaSetDto that = (QuotaSetDto) o;
        return quotaChangeCount == that.quotaChangeCount && status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, quotaChangeCount);
    }

    @Override
    public String toString() {
        return "QuotaSetDto{" +
                "status=" + status +
                ", quotaChangeCount=" + quotaChangeCount +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Status status;
        private Long quotaChangeCount;

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder quotaChangeCount(Long quotaChangeCount) {
            this.quotaChangeCount = quotaChangeCount;
            return this;
        }

        public QuotaSetDto build() {
            return new QuotaSetDto(Preconditions.checkNotNull(status, "Status is required"),
                    Preconditions.checkNotNull(quotaChangeCount, "QuotaChangeCount is required"));
        }
    }

    public enum Status {
        OK
    }
}
