package ru.yandex.intranet.d.web.model.quotas;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Quota transfer input DTO
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */

@Schema(description = "Quota transfer input DTO.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaTransferInputDto {
    private final List<Transfer> transfers;
    private final String comment;

    @JsonCreator
    public QuotaTransferInputDto(@JsonProperty("transfers") List<Transfer> transfers,
                                 @JsonProperty("comment") String comment) {
        this.transfers = transfers;
        this.comment = comment;
    }

    @Schema(description = "Transfer list.", required = true)
    public List<Transfer> getTransfers() {
        return transfers;
    }

    @Schema(description = "Comment.", required = true)
    public String getComment() {
        return comment;
    }

    @Schema(description = "Quota transfer.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Transfer {
        private final String sourceFolderId;
        private final String destinationFolderId;
        private final Resource resource;
        private final Long amount;
        private final String amountUnitKey;

        @JsonCreator
        public Transfer(@JsonProperty("sourceFolderId") String sourceFolderId,
                        @JsonProperty("destinationFolderId") String destinationFolderId,
                        @JsonProperty("resource") Resource resource,
                        @JsonProperty("amount") Long amount,
                        @JsonProperty("amountUnitKey") String amountUnitKey) {
            this.sourceFolderId = sourceFolderId;
            this.destinationFolderId = destinationFolderId;
            this.resource = resource;
            this.amount = amount;
            this.amountUnitKey = amountUnitKey;
        }

        @Schema(description = "Source folder id.", required = true)
        public String getSourceFolderId() {
            return sourceFolderId;
        }

        @Schema(description = "Destination folder id.", required = true)
        public String getDestinationFolderId() {
            return destinationFolderId;
        }

        @Schema(description = "Resource.", required = true)
        public Resource getResource() {
            return resource;
        }

        @Schema(description = "Transferred amount.", required = true)
        public Long getAmount() {
            return amount;
        }

        @Schema(description = "Transferred amount unit key.", required = true)
        public String getAmountUnitKey() {
            return amountUnitKey;
        }
    }

    @Schema(description = "Resource id.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Resource {
        private final String providerId;
        private final String resourceId;
        private final ExternalResourceId externalResourceId;

        @JsonCreator
        public Resource(@JsonProperty("providerId") String providerId,
                        @JsonProperty("resourceId") String resourceId,
                        @JsonProperty("externalResourceId") ExternalResourceId externalResourceId) {
            this.providerId = providerId;
            this.resourceId = resourceId;
            this.externalResourceId = externalResourceId;
        }

        @Schema(description = "Provider id.", required = true)
        public String getProviderId() {
            return providerId;
        }

        @Nullable
        @Schema(description = "Resource id.")
        public String getResourceId() {
            return resourceId;
        }

        @Nullable
        @Schema(description = "External resource id.")
        public ExternalResourceId getExternalResourceId() {
            return externalResourceId;
        }
    }

    @Schema(description = "External resource id.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ExternalResourceId {
        private final String typeKey;
        private final List<Segment> segmentation;

        @JsonCreator
        public ExternalResourceId(@JsonProperty("typeKey") String typeKey,
                                  @JsonProperty("segmentation") List<Segment> segmentation) {
            this.typeKey = typeKey;
            this.segmentation = segmentation;
        }

        @Schema(description = "Resource type key.", required = true)
        public String getTypeKey() {
            return typeKey;
        }

        @Schema(description = "Resource segments.", required = true)
        public List<Segment> getSegmentation() {
            return segmentation;
        }
    }

    @Schema(description = "External resource segment.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Segment {
        private final String segmentationKey;
        private final String segmentKey;

        @JsonCreator
        public Segment(@JsonProperty("segmentationKey") String segmentationKey,
                       @JsonProperty("segmentKey") String segmentKey) {
            this.segmentationKey = segmentationKey;
            this.segmentKey = segmentKey;
        }

        @Schema(description = "Resource segmentation key.", required = true)
        public String getSegmentationKey() {
            return segmentationKey;
        }

        @Schema(description = "Resource segment key.", required = true)
        public String getSegmentKey() {
            return segmentKey;
        }
    }
}
