package ru.yandex.intranet.d.web.model.quotas;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Statistic about quotas move
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Statistic about quotas move.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotasMoveStatisticDto {
    private final List<String> transfersCreatedIds;
    private final List<String> transfersAppliedIds;
    private final List<String> transfersCreatedLinks;
    private final List<String> transfersAppliedLinks;

    @JsonCreator
    public QuotasMoveStatisticDto(List<String> transfersCreatedIds, List<String> transfersAppliedIds,
                                  List<String> transfersCreatedLinks, List<String> transfersAppliedLinks) {
        this.transfersCreatedIds = transfersCreatedIds;
        this.transfersAppliedIds = transfersAppliedIds;
        this.transfersCreatedLinks = transfersCreatedLinks;
        this.transfersAppliedLinks = transfersAppliedLinks;
    }

    @Schema(description = "Transfers created ids.", required = true)
    public List<String> getTransfersCreatedIds() {
        return transfersCreatedIds;
    }

    @Schema(description = "Transfers applied ids.", required = true)
    public List<String> getTransfersAppliedIds() {
        return transfersAppliedIds;
    }

    @Schema(description = "Transfers created links.", required = true)
    public List<String> getTransfersCreatedLinks() {
        return transfersCreatedLinks;
    }

    @Schema(description = "Transfers applied links.", required = true)
    public List<String> getTransfersAppliedLinks() {
        return transfersAppliedLinks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotasMoveStatisticDto that = (QuotasMoveStatisticDto) o;
        return Objects.equals(transfersCreatedIds, that.transfersCreatedIds)
                && Objects.equals(transfersAppliedIds, that.transfersAppliedIds)
                && Objects.equals(transfersCreatedLinks, that.transfersCreatedLinks)
                && Objects.equals(transfersAppliedLinks, that.transfersAppliedLinks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transfersCreatedIds, transfersAppliedIds, transfersCreatedLinks, transfersAppliedLinks);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
