package ru.yandex.intranet.d.web.model.quotas;

import java.time.Instant;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Quotas move statistic request
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Quotas move statistic request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotasMoveStatisticInputDto {

    private final Instant dateFrom;
    private final Instant dateTo;
    private final List<Long> parentServiceIds;

    @JsonCreator
    public QuotasMoveStatisticInputDto(Instant dateFrom, Instant dateTo, List<Long> parentServiceIds) {
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.parentServiceIds = parentServiceIds;
    }

    @Schema(description = "From date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    public Instant getDateFrom() {
        return dateFrom;
    }

    @Schema(description = "To date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    public Instant getDateTo() {
        return dateTo;
    }

    @Schema(description = "Service ids.", required = true)
    public List<Long> getParentServiceIds() {
        return parentServiceIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotasMoveStatisticInputDto that = (QuotasMoveStatisticInputDto) o;
        return Objects.equals(dateFrom, that.dateFrom)
                && Objects.equals(dateTo, that.dateTo)
                && Objects.equals(parentServiceIds, that.parentServiceIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dateFrom, dateTo, parentServiceIds);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
