package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Values for Update Provisions form.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-03-2021
 */
@Schema(description = "Values for Update Provisions form.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionDryRunAmounts {
    private final String quota;
    private final String balance;
    private final String provided;
    private final String allocated;
    private final String forEditUnitId;

    @SuppressWarnings("checkstyle:ParameterNumber")
    @JsonCreator
    public UpdateProvisionDryRunAmounts(
            String quota,
            String balance,
            String provided,
            String allocated,
            String forEditUnitId
    ) {
        this.quota = quota;
        this.balance = balance;
        this.provided = provided;
        this.allocated = allocated;
        this.forEditUnitId = forEditUnitId;
    }

    @Schema(description = "Total quota of resource.", required = true)
    public String getQuota() {
        return quota;
    }

    @Schema(description = "The balance. Free (not provided) quota. Total quota minus sum of provided and frozen.",
            required = true)
    public String getBalance() {
        return balance;
    }

    @Schema(description = "Provided to account quota.", required = true)
    public String getProvided() {
        return provided;
    }

    @Schema(description = "Allocated in account quota.", required = true)
    public String getAllocated() {
        return allocated;
    }

    @Schema(description = "Unit ID for all amounts.", required = true)
    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionDryRunAmounts that = (UpdateProvisionDryRunAmounts) o;
        return Objects.equals(quota, that.quota) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(provided, that.provided) &&
                Objects.equals(allocated, that.allocated) &&
                Objects.equals(forEditUnitId, that.forEditUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quota, balance, provided, allocated, forEditUnitId);
    }

    @Override
    public String toString() {
        return "UpdateProvisionDryRunAmounts{" +
                "quota=" + quota +
                ", balance=" + balance +
                ", provided=" + provided +
                ", allocated=" + allocated +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                '}';
    }
}
