package ru.yandex.intranet.d.web.model.quotas;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.AmountDto;
import ru.yandex.intranet.d.web.model.ValidationMessagesDto;

/**
 * Result of fields recalculation for Update Provisions form.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-03-2021
 */
@Schema(description = "Result of fields recalculation for Update Provisions form.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateProvisionDryRunAnswerDto {
    private final String balance;
    private final String providedAbsolute;
    private final String forEditUnitId;
    private final String providedDelta;
    private final String providedAbsoluteInMinAllowedUnit;
    private final String minAllowedUnitId;
    private final String allocated;
    private final String allocatedRatio;
    private final String providedRatio;
    private final AmountDto balanceAmount;
    private final AmountDto providedAmount;
    private final AmountDto deltaAmount;
    private final Map<String, UpdateProvisionDryRunAnswerDto> relatedResources;
    private final ValidationMessagesDto validationMessages;

    @SuppressWarnings("checkstyle:ParameterNumber")
    @JsonCreator
    public UpdateProvisionDryRunAnswerDto(
            String balance,
            String providedAbsolute,
            String providedRatio,
            String allocated,
            String allocatedRatio,
            String forEditUnitId,
            String providedDelta,
            String providedAbsoluteInMinAllowedUnit,
            String minAllowedUnitId,
            AmountDto balanceAmount,
            AmountDto providedAmount,
            AmountDto deltaAmount,
            Map<String, UpdateProvisionDryRunAnswerDto> relatedResources,
            ValidationMessagesDto validationMessages
    ) {
        this.balance = balance;
        this.providedAbsolute = providedAbsolute;
        this.allocated = allocated;
        this.forEditUnitId = forEditUnitId;
        this.allocatedRatio = allocatedRatio;
        this.providedRatio = providedRatio;
        this.providedDelta = providedDelta;
        this.providedAbsoluteInMinAllowedUnit = providedAbsoluteInMinAllowedUnit;
        this.minAllowedUnitId = minAllowedUnitId;
        this.balanceAmount = balanceAmount;
        this.providedAmount = providedAmount;
        this.deltaAmount = deltaAmount;
        this.relatedResources = relatedResources;
        this.validationMessages = validationMessages;
    }

    @Schema(description = "The balance. Free (not provided) quota. Total quota minus sum of provided and frozen.",
            required = true)
    public String getBalance() {
        return balance;
    }

    @Schema(description = "Provided to account quota.", required = true)
    public String getProvidedAbsolute() {
        return providedAbsolute;
    }

    @Schema(description = "Provided quota divide total quota.", required = true)
    public String getProvidedRatio() {
        return providedRatio;
    }

    @Schema(description = "Allocated in account quota.", required = true)
    public String getAllocated() {
        return allocated;
    }

    @Schema(description = "Allocated quota divide provided quota.", required = true)
    public String getAllocatedRatio() {
        return allocatedRatio;
    }

    @Schema(description = "Unit ID for all amounts excepts 'providedAbsoluteValueInMinAllowedUnit'.", required = true)
    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @Schema(description = "New provided quota delta value.")
    public String getProvidedDelta() {
        return providedDelta;
    }

    @Schema(description = "New provided quota absolute value in minimum allowed unit, for UpdateProvisions handle.")
    public String getProvidedAbsoluteInMinAllowedUnit() {
        return providedAbsoluteInMinAllowedUnit;
    }

    @Schema(description = "Minimum allowed unit ID.", required = true)
    public String getMinAllowedUnitId() {
        return minAllowedUnitId;
    }

    @Schema(description = "New balance of quota.", required = true)
    public AmountDto getBalanceAmount() {
        return balanceAmount;
    }

    @Schema(description = "New provided quota.", required = true)
    public AmountDto getProvidedAmount() {
        return providedAmount;
    }

    @Schema(description = "New delta of quota.", required = true)
    public AmountDto getDeltaAmount() {
        return deltaAmount;
    }

    @Schema(description = "Recommended values of related resources.", required = true)
    public Map<String, UpdateProvisionDryRunAnswerDto> getRelatedResources() {
        return relatedResources;
    }

    @Schema(nullable = true)
    public ValidationMessagesDto getValidationMessages() {
        return validationMessages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionDryRunAnswerDto that = (UpdateProvisionDryRunAnswerDto) o;
        return Objects.equals(balance, that.balance) &&
                Objects.equals(providedAbsolute, that.providedAbsolute) &&
                Objects.equals(allocated, that.allocated) &&
                Objects.equals(forEditUnitId, that.forEditUnitId) &&
                Objects.equals(providedDelta, that.providedDelta) &&
                Objects.equals(providedAbsoluteInMinAllowedUnit, that.providedAbsoluteInMinAllowedUnit) &&
                Objects.equals(minAllowedUnitId, that.minAllowedUnitId) &&
                Objects.equals(allocatedRatio, that.allocatedRatio) &&
                Objects.equals(providedRatio, that.providedRatio) &&
                Objects.equals(balanceAmount, that.balanceAmount) &&
                Objects.equals(providedAmount, that.providedAmount) &&
                Objects.equals(deltaAmount, that.deltaAmount) &&
                Objects.equals(relatedResources, that.relatedResources) &&
                Objects.equals(validationMessages, that.validationMessages);
    }

    @Override
    public int hashCode() {
        return Objects.hash(balance, providedAbsolute, allocated, forEditUnitId, providedDelta,
                providedAbsoluteInMinAllowedUnit, minAllowedUnitId, allocatedRatio, providedRatio,
                balanceAmount, providedAmount, deltaAmount, relatedResources, validationMessages);
    }

    @Override
    public String toString() {
        return "UpdateProvisionDryRunAnswerDto{" +
                "balance='" + balance + '\'' +
                ", providedAbsolute='" + providedAbsolute + '\'' +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                ", providedDelta='" + providedDelta + '\'' +
                ", providedAbsoluteInMinAllowedUnit='" + providedAbsoluteInMinAllowedUnit + '\'' +
                ", minAllowedUnitId='" + minAllowedUnitId + '\'' +
                ", allocated='" + allocated + '\'' +
                ", allocatedRatio='" + allocatedRatio + '\'' +
                ", providedRatio='" + providedRatio + '\'' +
                ", balanceAmount=" + balanceAmount +
                ", providedAmount=" + providedAmount +
                ", deltaAmount=" + deltaAmount +
                ", relatedResources=" + relatedResources +
                ", validationMessages=" + validationMessages +
                '}';
    }

    public static class Builder {

        private String balance;
        private String providedAbsolute;
        private String providedRatio;
        private String allocated;
        private String allocatedRatio;
        private String forEditUnitId;
        private String providedDelta;
        private String providedAbsoluteInMinAllowedUnit;
        private String minAllowedUnitId;
        private AmountDto balanceAmount;
        private AmountDto providedAmount;
        private AmountDto deltaAmount;
        private Map<String, UpdateProvisionDryRunAnswerDto> relatedResources = new HashMap<>();
        private ValidationMessagesDto validationMessages;

        public Builder() {
        }

        public Builder(UpdateProvisionDryRunAnswerDto dto) {
            this.balance = dto.balance;
            this.providedAbsolute = dto.providedAbsolute;
            this.providedRatio = dto.providedRatio;
            this.allocated = dto.allocated;
            this.allocatedRatio = dto.allocatedRatio;
            this.forEditUnitId = dto.forEditUnitId;
            this.providedDelta = dto.providedDelta;
            this.providedAbsoluteInMinAllowedUnit = dto.providedAbsoluteInMinAllowedUnit;
            this.minAllowedUnitId = dto.minAllowedUnitId;
            this.balanceAmount = dto.balanceAmount;
            this.providedAmount = dto.providedAmount;
            this.deltaAmount = dto.deltaAmount;
            this.relatedResources = dto.relatedResources;
            this.validationMessages = dto.validationMessages;
        }

        public Builder setBalance(String balance) {
            this.balance = balance;
            return this;
        }

        public Builder setProvidedAbsolute(String providedAbsolute) {
            this.providedAbsolute = providedAbsolute;
            return this;
        }

        public Builder setProvidedRatio(String providedRatio) {
            this.providedRatio = providedRatio;
            return this;
        }

        public Builder setAllocated(String allocated) {
            this.allocated = allocated;
            return this;
        }

        public Builder setAllocatedRatio(String allocatedRatio) {
            this.allocatedRatio = allocatedRatio;
            return this;
        }

        public Builder setForEditUnitId(String forEditUnitId) {
            this.forEditUnitId = forEditUnitId;
            return this;
        }

        public Builder setProvidedDelta(String providedDelta) {
            this.providedDelta = providedDelta;
            return this;
        }

        public Builder setProvidedAbsoluteInMinAllowedUnit(String providedAbsoluteInMinAllowedUnit) {
            this.providedAbsoluteInMinAllowedUnit = providedAbsoluteInMinAllowedUnit;
            return this;
        }

        public Builder setMinAllowedUnitId(String minAllowedUnitId) {
            this.minAllowedUnitId = minAllowedUnitId;
            return this;
        }

        public Builder setBalanceAmount(AmountDto balanceAmount) {
            this.balanceAmount = balanceAmount;
            return this;
        }

        public Builder setProvidedAmount(AmountDto providedAmount) {
            this.providedAmount = providedAmount;
            return this;
        }

        public Builder setDeltaAmount(AmountDto deltaAmount) {
            this.deltaAmount = deltaAmount;
            return this;
        }

        @SuppressWarnings("UnusedReturnValue") // API
        public Builder addRelatedResource(String resourceId, UpdateProvisionDryRunAnswerDto relatedResource) {
            this.relatedResources.put(resourceId, relatedResource);
            return this;
        }

        public Builder setRelatedResources(Map<String, UpdateProvisionDryRunAnswerDto> relatedResourcesValues) {
            this.relatedResources = relatedResourcesValues;
            return this;
        }

        @SuppressWarnings("UnusedReturnValue") // API
        public Builder setValidationMessages(ValidationMessagesDto validationMessages) {
            this.validationMessages = validationMessages;
            return this;
        }

        public UpdateProvisionDryRunAnswerDto build() {
            return new UpdateProvisionDryRunAnswerDto(
                    balance,
                    providedAbsolute,
                    providedRatio,
                    allocated,
                    allocatedRatio,
                    forEditUnitId,
                    providedDelta,
                    providedAbsoluteInMinAllowedUnit,
                    minAllowedUnitId,
                    balanceAmount,
                    providedAmount,
                    deltaAmount,
                    relatedResources,
                    validationMessages
            );
        }
    }
}
