package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Folder quota for recalculate related resources for Update Provisions form.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Folder quotas for recalculate related resources for Update Provisions form.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionDryRunFolderQuotaDto {
    private final String resourceId;
    private final String quota;
    private final String balance;
    private final String provided;
    private final String allocated;
    private final String forEditUnitId;
    private final String formFieldUnitId;

    @JsonCreator
    public UpdateProvisionDryRunFolderQuotaDto(String resourceId, String quota, String balance, String provided,
                                               String allocated, String forEditUnitId, String formFieldUnitId) {
        this.resourceId = resourceId;
        this.quota = quota;
        this.balance = balance;
        this.provided = provided;
        this.allocated = allocated;
        this.forEditUnitId = forEditUnitId;
        this.formFieldUnitId = formFieldUnitId;
    }


    @Schema(description = "Resource id", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Total quota of resource.", required = true)
    public String getQuota() {
        return quota;
    }

    @Schema(description = "The balance. Free (not provided) quota. Total quota minus sum of provided and frozen.",
            required = true)
    public String getBalance() {
        return balance;
    }

    @Schema(description = "Provided to account quota.", required = true)
    public String getProvided() {
        return provided;
    }

    @Schema(description = "Allocated in account quota.", required = true)
    public String getAllocated() {
        return allocated;
    }

    @Schema(description = "Unit ID for all amounts.", required = true)
    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @Schema(description = "Unit ID for fields values, if it changed.")
    public String getFormFieldUnitId() {
        return formFieldUnitId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionDryRunFolderQuotaDto that = (UpdateProvisionDryRunFolderQuotaDto) o;
        return Objects.equals(resourceId, that.resourceId) && Objects.equals(quota, that.quota) &&
                Objects.equals(balance, that.balance) && Objects.equals(provided, that.provided) &&
                Objects.equals(allocated, that.allocated) && Objects.equals(forEditUnitId, that.forEditUnitId) &&
                Objects.equals(formFieldUnitId, that.formFieldUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, quota, balance, provided, allocated, forEditUnitId, formFieldUnitId);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
