package ru.yandex.intranet.d.web.model.quotas;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Data to recalculate fields for Update Provisions form.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03-03-2021
 */
@Schema(description = "Data to recalculate fields for Update Provisions form.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateProvisionDryRunRequestDto {
    protected final String resourceId;
    protected final UpdateProvisionDryRunAmounts oldAmounts;
    protected final OldEditFormFields oldFormFields;
    protected final EditedField editedField;
    protected final ChangedEditFormField newFormFields;
    protected final Map<String, UpdateProvisionDryRunFolderQuotaDto> folderQuotasByResourceId;

    @JsonCreator
    public UpdateProvisionDryRunRequestDto(
            String resourceId,
            UpdateProvisionDryRunAmounts oldAmounts,
            OldEditFormFields oldFormFields,
            ChangedEditFormField newFormFields,
            EditedField editedField,
            Map<String, UpdateProvisionDryRunFolderQuotaDto> relatedResources
    ) {
        this.resourceId = resourceId;
        this.oldAmounts = oldAmounts;
        this.oldFormFields = oldFormFields;
        this.newFormFields = newFormFields;
        this.editedField = editedField;
        this.folderQuotasByResourceId = relatedResources;
    }

    @Schema(description = "Resource id", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Current amounts values. Old means before any operations.", required = true)
    public UpdateProvisionDryRunAmounts getOldAmounts() {
        return oldAmounts;
    }

    @Schema(description = "Previous values of form fields.", required = true)
    public OldEditFormFields getOldFormFields() {
        return oldFormFields;
    }

    @Schema(description = "Changed value from one of fields. Other values should be null.", required = true)
    public ChangedEditFormField getNewFormFields() {
        return newFormFields;
    }

    @Schema(description = "Determine changed field.", required = true)
    public EditedField getEditedField() {
        return editedField;
    }

    @Schema(description = "Values of other resources from folder.")
    public Map<String, UpdateProvisionDryRunFolderQuotaDto> getFolderQuotasByResourceId() {
        return folderQuotasByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionDryRunRequestDto that = (UpdateProvisionDryRunRequestDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(oldAmounts, that.oldAmounts) &&
                Objects.equals(oldFormFields, that.oldFormFields) &&
                editedField == that.editedField &&
                Objects.equals(newFormFields, that.newFormFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, oldAmounts, oldFormFields, editedField, newFormFields);
    }

    @Override
    public String toString() {
        return "UpdateProvisionDryRunRequestDto{" +
                "resourceId='" + resourceId + '\'' +
                ", oldAmounts=" + oldAmounts +
                ", oldFormFields=" + oldFormFields +
                ", editedField=" + editedField +
                ", newFormFields=" + newFormFields +
                '}';
    }

    @Schema(description = "Previous values of form fields.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class OldEditFormFields {
        private final String providedAbsolute;
        private final String providedDelta;
        private final String unitId;
        private final String providedAbsoluteInMinAllowedUnit;
        private final String minAllowedUnitId;

        @JsonCreator
        public OldEditFormFields(
                String providedAbsolute,
                String providedDelta,
                String unitId,
                String providedAbsoluteInMinAllowedUnit, String minAllowedUnitId) {
            this.providedAbsolute = providedAbsolute;
            this.providedDelta = providedDelta;
            this.unitId = unitId;
            this.providedAbsoluteInMinAllowedUnit = providedAbsoluteInMinAllowedUnit;
            this.minAllowedUnitId = minAllowedUnitId;
        }

        @Schema(description = "New provided quota absolute field value.")
        public String getProvidedAbsolute() {
            return providedAbsolute;
        }

        @Schema(description = "New provided quota delta field value.")
        public String getProvidedDelta() {
            return providedDelta;
        }

        @Schema(description = "Unit ID for fields values.")
        public String getUnitId() {
            return unitId;
        }

        @Schema(description = "New provided quota absolute value in minimum allowed unit, if it has obtained." +
                " Or copy of 'providedAbsolute' for first call.")
        public String getProvidedAbsoluteInMinAllowedUnit() {
            return providedAbsoluteInMinAllowedUnit;
        }

        @Schema(description = "Unit ID for field 'providedAbsoluteInMinAllowedUnit'." +
                " Or copy of 'unitId' for first call.")
        public String getMinAllowedUnitId() {
            return minAllowedUnitId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            OldEditFormFields that = (OldEditFormFields) o;
            return Objects.equals(providedAbsolute, that.providedAbsolute) &&
                    Objects.equals(providedDelta, that.providedDelta) &&
                    Objects.equals(unitId, that.unitId) &&
                    Objects.equals(providedAbsoluteInMinAllowedUnit, that.providedAbsoluteInMinAllowedUnit) &&
                    Objects.equals(minAllowedUnitId, that.minAllowedUnitId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(providedAbsolute, providedDelta, unitId, providedAbsoluteInMinAllowedUnit,
                    minAllowedUnitId);
        }

        @Override
        public String toString() {
            return "EditFormFields{" +
                    "providedAbsolute=" + providedAbsolute +
                    ", providedDelta=" + providedDelta +
                    ", unitId='" + unitId + '\'' +
                    ", providedAbsoluteInMinAllowedUnit=" + providedAbsoluteInMinAllowedUnit +
                    ", minAllowedUnitId='" + minAllowedUnitId + '\'' +
                    '}';
        }
    }

    @Schema(description = "Changed value from one of fields. Other values should be null.")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class ChangedEditFormField {
        private final String providedAbsolute;
        private final String providedDelta;
        private final String unitId;

        @JsonCreator
        public ChangedEditFormField(
                String providedAbsolute,
                String providedDelta,
                String unitId
        ) {
            this.providedAbsolute = providedAbsolute;
            this.providedDelta = providedDelta;
            this.unitId = unitId;
        }

        @Schema(description = "New provided quota absolute field value, if it changed.")
        public String getProvidedAbsolute() {
            return providedAbsolute;
        }

        @Schema(description = "New provided quota delta field value, if it changed.")
        public String getProvidedDelta() {
            return providedDelta;
        }

        @Schema(description = "Unit ID for fields values, if it changed.")
        public String getUnitId() {
            return unitId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ChangedEditFormField that = (ChangedEditFormField) o;
            return Objects.equals(providedAbsolute, that.providedAbsolute) && Objects.equals(providedDelta,
                    that.providedDelta) && Objects.equals(unitId, that.unitId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(providedAbsolute, providedDelta, unitId);
        }

        @Override
        public String toString() {
            return "NewEditFormFields{" +
                    "providedAbsolute=" + providedAbsolute +
                    ", providedDelta=" + providedDelta +
                    ", unitId='" + unitId + '\'' +
                    '}';
        }
    }

    @Schema(description = "Determine changed field.")
    public enum EditedField {
        ABSOLUTE,
        DELTA,
        UNIT
    }
}
