package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.folders.front.ExpandedProvider;

/**
 * Update provisions answer dto.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 24-12-2020
 */
@Schema(description = "Update provision answer.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionsAnswerDto {
    private final ExpandedProvider expandedProvider;
    private final AccountsQuotasOperationsDto accountsQuotasOperationsDto;

    @JsonCreator
    public UpdateProvisionsAnswerDto(
            @JsonProperty("expandedProvider")ExpandedProvider expandedProvider,
            @JsonProperty("accountsQuotasOperationsDto")AccountsQuotasOperationsDto accountsQuotasOperationsDto) {
        this.expandedProvider = expandedProvider;
        this.accountsQuotasOperationsDto = accountsQuotasOperationsDto;
    }

    @Schema(description = "Expanded provider.", required = true)
    public ExpandedProvider getExpandedProvider() {
        return expandedProvider;
    }

    @Schema(description = "Accounts quotas operation.")
    public AccountsQuotasOperationsDto getAccountsQuotasOperationsDto() {
        return accountsQuotasOperationsDto;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionsAnswerDto that = (UpdateProvisionsAnswerDto) o;
        return Objects.equals(expandedProvider, that.expandedProvider) &&
                Objects.equals(accountsQuotasOperationsDto, that.accountsQuotasOperationsDto);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expandedProvider, accountsQuotasOperationsDto);
    }

    @Override
    public String toString() {
        return "UpdateProvisionsAnswerDto{" +
                "expandedProvider=" + expandedProvider +
                ", accountsQuotasOperationsDto=" + accountsQuotasOperationsDto +
                '}';
    }
}
