package ru.yandex.intranet.d.web.model.quotas;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Update provisions request dto.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 25-12-2020
 */
@Schema(description = "Update provisions request body.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionsRequestDto {
    private final Long serviceId;
    private final String accountId;
    private final String folderId;
    private final List<ProvisionLiteDto> updatedProvisions;

    @JsonCreator
    public UpdateProvisionsRequestDto(
            @JsonProperty(value = "serviceId") Long serviceId,
            @JsonProperty(value = "accountId") String accountId,
            @JsonProperty(value = "folderId") String folderId,
            @JsonProperty(value = "updatedProvisions") List<ProvisionLiteDto> updatedProvisions
    ) {
        this.serviceId = serviceId;
        this.accountId = accountId;
        this.folderId = folderId;
        this.updatedProvisions = updatedProvisions;
    }

    @Schema(description = "Service id", required = true)
    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    @Schema(description = "Account id", required = true)
    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    @Schema(description = "Folder id", required = true)
    public Optional<String> getFolderId() {
        return Optional.ofNullable(folderId);
    }

    @Schema(description = "Updated provisions", required = true)
    public Optional<List<ProvisionLiteDto>> getUpdatedProvisions() {
        return Optional.ofNullable(updatedProvisions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionsRequestDto that = (UpdateProvisionsRequestDto) o;
        return Objects.equals(serviceId, that.serviceId) &&
                Objects.equals(accountId, that.accountId) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(updatedProvisions, that.updatedProvisions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, accountId, folderId, updatedProvisions);
    }

    @Override
    public String toString() {
        return "UpdateProvisionsRequestDto{" +
                "serviceId=" + serviceId +
                ", accountId='" + accountId + '\'' +
                ", folderId='" + folderId + '\'' +
                ", updatedProvisions=" + updatedProvisions +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long serviceId;
        private String accountId;
        private String folderId;
        private List<ProvisionLiteDto> updatedProvisions;

        public Builder setServiceId(Long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder setUpdatedProvisions(List<ProvisionLiteDto> updatedProvisions) {
            this.updatedProvisions = updatedProvisions;
            return this;
        }

        public UpdateProvisionsRequestDto build() {
            return new UpdateProvisionsRequestDto(serviceId, accountId, folderId, updatedProvisions);
        }
    }
}
