package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigDecimal;
import java.util.Objects;

public final class ValidatedUpdateProvisionDryRunAmounts {
    private final BigDecimal quota;
    private final BigDecimal balance;
    private final BigDecimal provided;
    private final BigDecimal allocated;
    private final String forEditUnitId;

    public ValidatedUpdateProvisionDryRunAmounts(BigDecimal quota, BigDecimal balance, BigDecimal provided,
                                                 BigDecimal allocated, String forEditUnitId) {
        this.quota = quota;
        this.balance = balance;
        this.provided = provided;
        this.allocated = allocated;
        this.forEditUnitId = forEditUnitId;
    }

    public BigDecimal getQuota() {
        return quota;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public BigDecimal getProvided() {
        return provided;
    }

    public BigDecimal getAllocated() {
        return allocated;
    }

    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedUpdateProvisionDryRunAmounts that = (ValidatedUpdateProvisionDryRunAmounts) o;
        return Objects.equals(quota, that.quota) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(provided, that.provided) &&
                Objects.equals(allocated, that.allocated) &&
                Objects.equals(forEditUnitId, that.forEditUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quota, balance, provided, allocated, forEditUnitId);
    }

    @Override
    public String toString() {
        return "ValidatedUpdateProvisionDryRunAmounts{" +
                "quota=" + quota +
                ", balance=" + balance +
                ", provided=" + provided +
                ", allocated=" + allocated +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                '}';
    }
}
