package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigDecimal;
import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Validated folder quota for recalculate related resources for Update Provisions form.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public final class ValidatedUpdateProvisionDryRunFolderQuota {
    private final String resourceId;
    private final BigDecimal quota;
    private final BigDecimal balance;
    private final BigDecimal provided;
    private final BigDecimal allocated;
    private final String forEditUnitId;
    private final String formFieldUnitId;

    public ValidatedUpdateProvisionDryRunFolderQuota(String resourceId, BigDecimal quota, BigDecimal balance,
                                                     BigDecimal provided, BigDecimal allocated,
                                                     String forEditUnitId, String formFieldUnitId) {
        this.resourceId = resourceId;
        this.quota = quota;
        this.balance = balance;
        this.provided = provided;
        this.allocated = allocated;
        this.forEditUnitId = forEditUnitId;
        this.formFieldUnitId = formFieldUnitId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public BigDecimal getQuota() {
        return quota;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public BigDecimal getProvided() {
        return provided;
    }

    public BigDecimal getAllocated() {
        return allocated;
    }

    public String getForEditUnitId() {
        return forEditUnitId;
    }

    public String getFormFieldUnitId() {
        return formFieldUnitId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedUpdateProvisionDryRunFolderQuota that = (ValidatedUpdateProvisionDryRunFolderQuota) o;
        return Objects.equals(resourceId, that.resourceId) && Objects.equals(quota, that.quota) &&
                Objects.equals(balance, that.balance) && Objects.equals(provided, that.provided) &&
                Objects.equals(allocated, that.allocated) && Objects.equals(forEditUnitId, that.forEditUnitId) &&
                Objects.equals(formFieldUnitId, that.formFieldUnitId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, quota, balance, provided, allocated, forEditUnitId, formFieldUnitId);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
