package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

public class ValidatedUpdateProvisionDryRunRequest {
    protected final String resourceId;
    protected final ValidatedUpdateProvisionDryRunAmounts oldAmounts;
    protected final ValidatedOldEditFormFields oldFormFields;
    protected final UpdateProvisionDryRunRequestDto.EditedField editedField;
    protected final ValidatedChangedEditFormField newFormFields;
    protected final Map<String, ValidatedUpdateProvisionDryRunFolderQuota> folderQuotasByResourceId;

    public ValidatedUpdateProvisionDryRunRequest(
            String resourceId,
            ValidatedUpdateProvisionDryRunAmounts oldAmounts,
            ValidatedOldEditFormFields oldFormFields,
            UpdateProvisionDryRunRequestDto.EditedField editedField,
            ValidatedChangedEditFormField newFormFields,
            Map<String, ValidatedUpdateProvisionDryRunFolderQuota> folderQuotasByResourceId
    ) {
        this.resourceId = resourceId;
        this.oldAmounts = oldAmounts;
        this.oldFormFields = oldFormFields;
        this.editedField = editedField;
        this.newFormFields = newFormFields;
        this.folderQuotasByResourceId = folderQuotasByResourceId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public ValidatedUpdateProvisionDryRunAmounts getOldAmounts() {
        return oldAmounts;
    }

    public ValidatedOldEditFormFields getOldFormFields() {
        return oldFormFields;
    }

    public UpdateProvisionDryRunRequestDto.EditedField getEditedField() {
        return editedField;
    }

    public ValidatedChangedEditFormField getNewFormFields() {
        return newFormFields;
    }

    public Map<String, ValidatedUpdateProvisionDryRunFolderQuota> getFolderQuotasByResourceId() {
        return folderQuotasByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedUpdateProvisionDryRunRequest that = (ValidatedUpdateProvisionDryRunRequest) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(oldAmounts, that.oldAmounts) &&
                Objects.equals(oldFormFields, that.oldFormFields) &&
                editedField == that.editedField &&
                Objects.equals(newFormFields, that.newFormFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, oldAmounts, oldFormFields, editedField, newFormFields);
    }

    @Override
    public String toString() {
        return "ValidatedUpdateProvisionDryRunRequest{" +
                "resourceId='" + resourceId + '\'' +
                ", oldAmounts=" + oldAmounts +
                ", oldFormFields=" + oldFormFields +
                ", editedField=" + editedField +
                ", newFormFields=" + newFormFields +
                '}';
    }

    public static final class ValidatedOldEditFormFields {
        private final BigDecimal providedAbsolute;
        private final BigDecimal providedDelta;
        private final String unitId;
        private final BigDecimal providedAbsoluteInMinAllowedUnit;
        private final String minAllowedUnitId;

        public ValidatedOldEditFormFields(
                BigDecimal providedAbsolute,
                BigDecimal providedDelta,
                String unitId,
                BigDecimal providedAbsoluteInMinAllowedUnit, String minAllowedUnitId) {
            this.providedAbsolute = providedAbsolute;
            this.providedDelta = providedDelta;
            this.unitId = unitId;
            this.providedAbsoluteInMinAllowedUnit = providedAbsoluteInMinAllowedUnit;
            this.minAllowedUnitId = minAllowedUnitId;
        }

        public BigDecimal getProvidedAbsolute() {
            return providedAbsolute;
        }

        public BigDecimal getProvidedDelta() {
            return providedDelta;
        }

        public String getUnitId() {
            return unitId;
        }

        public BigDecimal getProvidedAbsoluteInMinAllowedUnit() {
            return providedAbsoluteInMinAllowedUnit;
        }

        public String getMinAllowedUnitId() {
            return minAllowedUnitId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ValidatedOldEditFormFields that = (ValidatedOldEditFormFields) o;
            return Objects.equals(providedAbsolute, that.providedAbsolute) &&
                    Objects.equals(providedDelta, that.providedDelta) &&
                    Objects.equals(unitId, that.unitId) &&
                    Objects.equals(providedAbsoluteInMinAllowedUnit, that.providedAbsoluteInMinAllowedUnit) &&
                    Objects.equals(minAllowedUnitId, that.minAllowedUnitId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(providedAbsolute, providedDelta, unitId, providedAbsoluteInMinAllowedUnit,
                    minAllowedUnitId);
        }

        @Override
        public String toString() {
            return "ValidatedOldEditFormFields{" +
                    "providedAbsolute=" + providedAbsolute +
                    ", providedDelta=" + providedDelta +
                    ", unitId='" + unitId + '\'' +
                    ", providedAbsoluteInMinAllowedUnit=" + providedAbsoluteInMinAllowedUnit +
                    ", minAllowedUnitId='" + minAllowedUnitId + '\'' +
                    '}';
        }
    }

    public static final class ValidatedChangedEditFormField {
        private final BigDecimal providedAbsolute;
        private final BigDecimal providedDelta;
        private final String unitId;

        public ValidatedChangedEditFormField(
                BigDecimal providedAbsolute,
                BigDecimal providedDelta,
                String unitId
        ) {
            this.providedAbsolute = providedAbsolute;
            this.providedDelta = providedDelta;
            this.unitId = unitId;
        }

        public BigDecimal getProvidedAbsolute() {
            return providedAbsolute;
        }

        public BigDecimal getProvidedDelta() {
            return providedDelta;
        }

        public String getUnitId() {
            return unitId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ValidatedChangedEditFormField that = (ValidatedChangedEditFormField) o;
            return Objects.equals(providedAbsolute, that.providedAbsolute) &&
                    Objects.equals(providedDelta, that.providedDelta) &&
                    Objects.equals(unitId, that.unitId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(providedAbsolute, providedDelta, unitId);
        }

        @Override
        public String toString() {
            return "ValidatedChangedEditFormField{" +
                    "providedAbsolute=" + providedAbsolute +
                    ", providedDelta=" + providedDelta +
                    ", unitId='" + unitId + '\'' +
                    '}';
        }
    }

}
