package ru.yandex.intranet.d.web.model.recipe;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Accounts.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Accounts.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsDto {

    private final List<AccountDto> accounts;

    @JsonCreator
    public AccountsDto(List<AccountDto> accounts) {
        this.accounts = accounts;
    }

    @Schema(description = "Accounts.", required = true)
    public List<AccountDto> getAccounts() {
        return accounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsDto that = (AccountsDto) o;
        return Objects.equals(accounts, that.accounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accounts);
    }

    @Override
    public String toString() {
        return "AccountsDto{" +
                "accounts=" + accounts +
                '}';
    }

}
