package ru.yandex.intranet.d.web.model.recipe;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Accounts quotas.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Accounts quotas.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsQuotasDto {

    private final List<AccountQuotaDto> accountsQuotas;

    @JsonCreator
    public AccountsQuotasDto(List<AccountQuotaDto> accountsQuotas) {
        this.accountsQuotas = accountsQuotas;
    }

    @Schema(description = "Accounts quotas.", required = true)
    public List<AccountQuotaDto> getAccountsQuotas() {
        return accountsQuotas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsQuotasDto that = (AccountsQuotasDto) o;
        return Objects.equals(accountsQuotas, that.accountsQuotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountsQuotas);
    }

    @Override
    public String toString() {
        return "AccountsQuotasDto{" +
                "accountsQuotas=" + accountsQuotas +
                '}';
    }

}
