package ru.yandex.intranet.d.web.model.recipe;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * New service.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Service.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateServiceDto {

    private final Long id;
    private final String nameEn;
    private final String nameRu;
    private final String slug;
    private final Long parentId;

    @JsonCreator
    public CreateServiceDto(Long id, String nameEn, String nameRu, String slug, Long parentId) {
        this.id = id;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.slug = slug;
        this.parentId = parentId;
    }

    @Schema(description = "Id.", required = true)
    public Optional<Long> getId() {
        return Optional.ofNullable(id);
    }

    @Schema(description = "Name english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Slug.", required = true)
    public Optional<String> getSlug() {
        return Optional.ofNullable(slug);
    }

    @Schema(description = "Parent id.")
    public Optional<Long> getParentId() {
        return Optional.ofNullable(parentId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateServiceDto that = (CreateServiceDto) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(slug, that.slug) &&
                Objects.equals(parentId, that.parentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, nameEn, nameRu, slug, parentId);
    }

    @Override
    public String toString() {
        return "CreateServiceDto{" +
                "id=" + id +
                ", nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", slug='" + slug + '\'' +
                ", parentId=" + parentId +
                '}';
    }

}
