package ru.yandex.intranet.d.web.model.recipe;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * New user.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "User.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateUserDto {

    private final String firstNameEn;
    private final String firstNameRu;
    private final String lastNameEn;
    private final String lastNameRu;
    private final String login;
    private final Long uid;
    private final String workEmail;
    private final String gender;
    private final String langUi;
    private final String timeZone;
    private final Map<Long, Set<Long>> rolesByService;
    private final Boolean admin;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public CreateUserDto(String firstNameEn,
                         String firstNameRu,
                         String lastNameEn,
                         String lastNameRu,
                         String login,
                         Long uid,
                         String workEmail,
                         String gender,
                         String langUi,
                         String timeZone,
                         Map<Long, Set<Long>> rolesByService,
                         Boolean admin) {
        this.firstNameEn = firstNameEn;
        this.firstNameRu = firstNameRu;
        this.lastNameEn = lastNameEn;
        this.lastNameRu = lastNameRu;
        this.login = login;
        this.uid = uid;
        this.workEmail = workEmail;
        this.gender = gender;
        this.langUi = langUi;
        this.timeZone = timeZone;
        this.rolesByService = rolesByService;
        this.admin = admin;
    }

    @Schema(description = "First name english.", required = true)
    public Optional<String> getFirstNameEn() {
        return Optional.ofNullable(firstNameEn);
    }

    @Schema(description = "First name russian.", required = true)
    public Optional<String> getFirstNameRu() {
        return Optional.ofNullable(firstNameRu);
    }

    @Schema(description = "Last name english.", required = true)
    public Optional<String> getLastNameEn() {
        return Optional.ofNullable(lastNameEn);
    }

    @Schema(description = "Last name russian.", required = true)
    public Optional<String> getLastNameRu() {
        return Optional.ofNullable(lastNameRu);
    }

    @Schema(description = "Login.", required = true)
    public Optional<String> getLogin() {
        return Optional.ofNullable(login);
    }

    @Schema(description = "Uid.", required = true)
    public Optional<Long> getUid() {
        return Optional.ofNullable(uid);
    }

    @Schema(description = "Work email.", required = true)
    public Optional<String> getWorkEmail() {
        return Optional.ofNullable(workEmail);
    }

    @Schema(description = "Gender.", required = true)
    public Optional<String> getGender() {
        return Optional.ofNullable(gender);
    }

    @Schema(description = "UI language.", required = true)
    public Optional<String> getLangUi() {
        return Optional.ofNullable(langUi);
    }

    @Schema(description = "Time zone.", required = true)
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    @Schema(description = "Roles by service.")
    public Optional<Map<Long, Set<Long>>> getRolesByService() {
        return Optional.ofNullable(rolesByService);
    }

    @Schema(description = "'Is admin' flag.", required = true)
    public Optional<Boolean> getAdmin() {
        return Optional.ofNullable(admin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateUserDto that = (CreateUserDto) o;
        return Objects.equals(firstNameEn, that.firstNameEn) &&
                Objects.equals(firstNameRu, that.firstNameRu) &&
                Objects.equals(lastNameEn, that.lastNameEn) &&
                Objects.equals(lastNameRu, that.lastNameRu) &&
                Objects.equals(login, that.login) &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(workEmail, that.workEmail) &&
                Objects.equals(gender, that.gender) &&
                Objects.equals(langUi, that.langUi) &&
                Objects.equals(timeZone, that.timeZone) &&
                Objects.equals(rolesByService, that.rolesByService) &&
                Objects.equals(admin, that.admin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(firstNameEn, firstNameRu, lastNameEn, lastNameRu, login, uid, workEmail, gender,
                langUi, timeZone, rolesByService, admin);
    }

    @Override
    public String toString() {
        return "CreateUserDto{" +
                "firstNameEn='" + firstNameEn + '\'' +
                ", firstNameRu='" + firstNameRu + '\'' +
                ", lastNameEn='" + lastNameEn + '\'' +
                ", lastNameRu='" + lastNameRu + '\'' +
                ", login='" + login + '\'' +
                ", uid=" + uid +
                ", workEmail='" + workEmail + '\'' +
                ", gender='" + gender + '\'' +
                ", langUi='" + langUi + '\'' +
                ", timeZone='" + timeZone + '\'' +
                ", rolesByService=" + rolesByService +
                ", admin=" + admin +
                '}';
    }

}
