package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.providers.ProviderUISettingsDto;

/**
 * AccountsSpaceDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 26.01.2021
 */
@Schema(description = "Accounts space.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpaceDto {
    private final String id;
    private final String key;
    private final String providerId;
    private final long version;
    private final String name;
    private final String description;
    private final boolean readOnly;
    private final Set<InnerResourceSegmentationSegmentDto> segments;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final boolean syncEnabled;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public AccountsSpaceDto(
            String id,
            String key,
            String providerId,
            long version,
            String name,
            String description,
            boolean readOnly, Set<InnerResourceSegmentationSegmentDto> segments,
            @Nullable ProviderUISettingsDto uiSettings,
            boolean syncEnabled
    ) {
        this.id = id;
        this.key = key;
        this.providerId = providerId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.readOnly = readOnly;
        this.segments = segments;
        this.uiSettings = uiSettings;
        this.syncEnabled = syncEnabled;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "Segments.", required = true)
    public Set<InnerResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "Sync with provider flag.", required = true)
    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpaceDto that = (AccountsSpaceDto) o;
        return version == that.version &&
                readOnly == that.readOnly &&
                syncEnabled == that.syncEnabled &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, providerId, version, name, description, readOnly, segments, uiSettings,
                syncEnabled);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
