package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceSegmentDto {

    private final String id;
    private final String key;
    private final String name;
    private final String description;
    private final boolean uncommon;

    @JsonCreator
    public InnerResourceSegmentDto(@JsonProperty("id") String id,
                                   @JsonProperty("key") String key,
                                   @JsonProperty("name") String name,
                                   @JsonProperty("description") String description,
                                   @JsonProperty("uncommon") boolean uncommon) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.description = description;
        this.uncommon = uncommon;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per segmentation.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "'Uncommon' flag.", required = true)
    public boolean isUncommon() {
        return uncommon;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceSegmentDto that = (InnerResourceSegmentDto) o;
        return uncommon == that.uncommon &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, description, uncommon);
    }

    @Override
    public String toString() {
        return "InnerResourceSegmentDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", uncommon=" + uncommon +
                '}';
    }

}
