package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.resources.directory.segmentations.SegmentationUISettingsDto;

/**
 * Resource segmentation DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceSegmentationDto {

    private final String id;
    private final String key;
    private final String name;
    private final String description;
    private final int groupingOrder;
    private final SegmentationUISettingsDto uiSettings;

    @JsonCreator
    public InnerResourceSegmentationDto(
            String id,
            String key,
            String name,
            String description,
            int groupingOrder,
            SegmentationUISettingsDto uiSettings
    ) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.description = description;
        this.groupingOrder = groupingOrder;
        this.uiSettings = uiSettings;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "Grouping order.", required = true)
    public int getGroupingOrder() {
        return groupingOrder;
    }

    @Schema(description = "UI Settings.")
    public SegmentationUISettingsDto getUiSettings() {
        return uiSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceSegmentationDto that = (InnerResourceSegmentationDto) o;
        return groupingOrder == that.groupingOrder &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, description, groupingOrder, uiSettings);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

}
