package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource segmentation segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceSegmentationSegmentDto {

    private final InnerResourceSegmentationDto segmentation;
    private final InnerResourceSegmentDto segment;

    @JsonCreator
    public InnerResourceSegmentationSegmentDto(
            @JsonProperty("segmentation") InnerResourceSegmentationDto segmentation,
            @JsonProperty("segment") InnerResourceSegmentDto segment) {
        this.segmentation = segmentation;
        this.segment = segment;
    }

    @Schema(description = "Segmentation.", required = true)
    public InnerResourceSegmentationDto getSegmentation() {
        return segmentation;
    }

    @Schema(description = "Segment.", required = true)
    public InnerResourceSegmentDto getSegment() {
        return segment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceSegmentationSegmentDto that = (InnerResourceSegmentationSegmentDto) o;
        return Objects.equals(segmentation, that.segmentation) &&
                Objects.equals(segment, that.segment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation, segment);
    }

    @Override
    public String toString() {
        return "InnerResourceSegmentationSegmentDto{" +
                "segmentation=" + segmentation +
                ", segment=" + segment +
                '}';
    }

}
