package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource type DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource type.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceTypeDto {

    private final String id;
    private final String key;
    private final String name;
    private final String description;

    @JsonCreator
    public InnerResourceTypeDto(@JsonProperty("id") String id,
                                @JsonProperty("key") String key,
                                @JsonProperty("name") String name,
                                @JsonProperty("description") String description) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.description = description;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceTypeDto that = (InnerResourceTypeDto) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, description);
    }

    @Override
    public String toString() {
        return "InnerResourceTypeDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                '}';
    }

}
