package ru.yandex.intranet.d.web.model.resources;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource type and segments DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource type and segments.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceTypeSegmentsDto {

    private final InnerResourceTypeDto resourceType;
    private final Set<InnerResourceSegmentationSegmentDto> segments;

    @JsonCreator
    public InnerResourceTypeSegmentsDto(@JsonProperty("resourceType") InnerResourceTypeDto resourceType,
                                        @JsonProperty("segments") Set<InnerResourceSegmentationSegmentDto> segments) {
        this.resourceType = resourceType;
        this.segments = segments;
    }

    @Schema(description = "Resource type.", required = true)
    public InnerResourceTypeDto getResourceType() {
        return resourceType;
    }

    @Schema(description = "Segments.", required = true)
    public Set<InnerResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceTypeSegmentsDto that = (InnerResourceTypeSegmentsDto) o;
        return Objects.equals(resourceType, that.resourceType) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceType, segments);
    }

    @Override
    public String toString() {
        return "InnerResourceTypeSegmentsDto{" +
                "resourceType=" + resourceType +
                ", segments=" + segments +
                '}';
    }

}
