package ru.yandex.intranet.d.web.model.resources

import com.fasterxml.jackson.annotation.JsonCreator
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.services.resources.SelectionTreeResourceDto
import ru.yandex.intranet.d.web.model.folders.front.ResourceTypeDto
import ru.yandex.intranet.d.web.model.units.front.FrontUnitsEnsembleDto

@Schema(description = "Resource selection list response DTO.")
data class ResourceSelectionListResponseDto @JsonCreator constructor(
    @get:Schema(description = "List of segmentations with their segments and resources.")
    val segmentations: List<ResourceSelectionListSegmentationDto>,
    @get:Schema(description = "Resource types of all resources that are present in the response, grouped by their ids.")
    val resourceTypes: Map<ResourceTypeId, ResourceTypeDto>,
    @get:Schema(description = "Map of all resources by their ids.")
    val resources: Map<ResourceId, SelectionTreeResourceDto>,
    @get:Schema(description = "Map of unit ensembles grouped by their ids.")
    val unitsEnsemblesById: Map<ResourceId, FrontUnitsEnsembleDto>
)
