package ru.yandex.intranet.d.web.model.resources

import com.fasterxml.jackson.annotation.JsonCreator
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId

@Schema(description = "Segment data and list of resources available in current and nested segments.")
data class ResourceSelectionListSegmentDto @JsonCreator constructor(
    @get:Schema(description = "Segment`s id.")
    val id: SegmentId,
    @get:Schema(description = "Segment`s key.")
    val key: String,
    @get:Schema(description = "Segment`s display name according to current locale.")
    val displayName: String,
    @get:Schema(description = "'Uncommon' flag.")
    val uncommon: Boolean,
    @get:Schema(description = "Map of resources` ids list grouped by resource types` ids.")
    val resourceIdsByResourceTypeIds: Map<ResourceTypeId, Set<ResourceId>>
)
