package ru.yandex.intranet.d.web.model.resources

import com.fasterxml.jackson.annotation.JsonCreator
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.web.model.resources.directory.segmentations.SegmentationUISettingsDto

@Schema(description = "Segmentation data and list of its segments.")
data class ResourceSelectionListSegmentationDto @JsonCreator constructor(
    @get:Schema(description = "Segmentation`s id.")
    val id: SegmentationId,
    @get:Schema(description = "Segmentation`s key.")
    val key: String,
    @get:Schema(description = "Segmentation`s display name according to current locale.")
    val displayName: String,
    @get:Schema(description = "Segmentations`s grouping order..")
    val groupingOrder: Int,
    @get:Schema(description = "UI Settings.")
    val uiSettingsDto: SegmentationUISettingsDto?,
    @get:Schema(description = "Set of all segments in the segmentation.")
    val segments: Set<ResourceSelectionListSegmentDto>
)
