package ru.yandex.intranet.d.web.model.resources;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * ResourceUnitsDto
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Resource units.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ResourceUnitsDto {
    private final List<String> allowedUnitIds;
    private final String defaultUnitId;
    private final String providerApiUnitId;

    public ResourceUnitsDto(List<String> allowedUnitIds,
                            String defaultUnitId,
                            String providerApiUnitId) {
        this.allowedUnitIds = allowedUnitIds;
        this.defaultUnitId = defaultUnitId;
        this.providerApiUnitId = providerApiUnitId;
    }

    @Schema(description = "Allowed unit ids.", required = true)
    public List<String> getAllowedUnitIds() {
        return allowedUnitIds;
    }

    @Schema(description = "Default unit id.", required = true)
    public String getDefaultUnitId() {
        return defaultUnitId;
    }

    @Schema(description = "Unit id, used to interact with provider.")
    public String getProviderApiUnitId() {
        return providerApiUnitId;
    }

    @Override
    public String toString() {
        return "ResourceUnitsDto{" +
                "allowedUnitIds=" + allowedUnitIds +
                ", defaultUnitId='" + defaultUnitId + '\'' +
                ", providerApiUnitId='" + providerApiUnitId + '\'' +
                '}';
    }
}
