package ru.yandex.intranet.d.web.model.resources.directory;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Create resource type and segments DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource type and segments.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CreateResourceTypeSegmentsDto {

    private final String resourceTypeId;
    private final List<CreateResourceSegmentationSegmentDto> segmentations;

    @JsonCreator
    public CreateResourceTypeSegmentsDto(
            @JsonProperty("resourceTypeId") String resourceTypeId,
            @JsonProperty("segmentations") List<CreateResourceSegmentationSegmentDto> segmentations) {
        this.resourceTypeId = resourceTypeId;
        this.segmentations = segmentations;
    }

    @Schema(description = "Resource type id.", required = true)
    public Optional<String> getResourceTypeId() {
        return Optional.ofNullable(resourceTypeId);
    }

    @Schema(description = "Segments.", required = true)
    public Optional<List<CreateResourceSegmentationSegmentDto>> getSegmentations() {
        return Optional.ofNullable(segmentations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateResourceTypeSegmentsDto that = (CreateResourceTypeSegmentsDto) o;
        return Objects.equals(resourceTypeId, that.resourceTypeId) &&
                Objects.equals(segmentations, that.segmentations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeId, segmentations);
    }

    @Override
    public String toString() {
        return "CreateResourceTypeSegmentsDto{" +
                "resourceTypeId='" + resourceTypeId + '\'' +
                ", segmentations=" + segmentations +
                '}';
    }

}
