package ru.yandex.intranet.d.web.model.resources.directory;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource segmentation segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceSegmentationSegmentDto {

    private final String segmentationId;
    private final String segmentId;

    @JsonCreator
    public InnerResourceSegmentationSegmentDto(@JsonProperty("segmentationId") String segmentationId,
                                               @JsonProperty("segmentId") String segmentId) {
        this.segmentationId = segmentationId;
        this.segmentId = segmentId;
    }

    @Schema(description = "Segmentation id.", required = true)
    public String getSegmentationId() {
        return segmentationId;
    }

    @Schema(description = "Segment id.", required = true)
    public String getSegmentId() {
        return segmentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceSegmentationSegmentDto that = (InnerResourceSegmentationSegmentDto) o;
        return Objects.equals(segmentationId, that.segmentationId) &&
                Objects.equals(segmentId, that.segmentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationId, segmentId);
    }

    @Override
    public String toString() {
        return "InnerResourceSegmentationSegmentDto{" +
                "segmentationId='" + segmentationId + '\'' +
                ", segmentId='" + segmentId + '\'' +
                '}';
    }

}
