package ru.yandex.intranet.d.web.model.resources.directory;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource type and segments DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource type and segments.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class InnerResourceTypeSegmentsDto {

    private final String resourceTypeId;
    private final Set<InnerResourceSegmentationSegmentDto> segmentations;

    @JsonCreator
    public InnerResourceTypeSegmentsDto(
            @JsonProperty("resourceTypeId") String resourceTypeId,
            @JsonProperty("segmentations") Set<InnerResourceSegmentationSegmentDto> segmentations) {
        this.resourceTypeId = resourceTypeId;
        this.segmentations = segmentations;
    }

    @Schema(description = "Resource type id.", required = true)
    public String getResourceTypeId() {
        return resourceTypeId;
    }

    @Schema(description = "Segments.", required = true)
    public Set<InnerResourceSegmentationSegmentDto> getSegmentations() {
        return segmentations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InnerResourceTypeSegmentsDto that = (InnerResourceTypeSegmentsDto) o;
        return Objects.equals(resourceTypeId, that.resourceTypeId) &&
                Objects.equals(segmentations, that.segmentations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeId, segmentations);
    }

    @Override
    public String toString() {
        return "InnerResourceTypeSegmentsDto{" +
                "resourceTypeId='" + resourceTypeId + '\'' +
                ", segmentations=" + segmentations +
                '}';
    }

}
