package ru.yandex.intranet.d.web.model.resources.directory;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.FeatureStateInputDto;
import ru.yandex.intranet.d.web.model.providers.AggregationSettingsInputDto;

/**
 * Create resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceCreateDto {

    private final String key;
    private final String unitsEnsembleId;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final Boolean readOnly;
    private final Boolean orderable;
    private final Boolean managed;
    private final List<String> allowedUnitIds;
    private final String defaultUnitId;
    private final String providerApiUnitId;
    private final CreateResourceTypeSegmentsDto segmentations;
    private final Long defaultQuota;
    private final Boolean virtual;
    private final FeatureStateInputDto allocatedSupported;
    private final @Nullable AggregationSettingsInputDto aggregationSettings;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ResourceCreateDto(
            String key,
            String unitsEnsembleId,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            Boolean readOnly,
            Boolean orderable,
            Boolean managed,
            List<String> allowedUnitIds,
            String defaultUnitId,
            String providerApiUnitId,
            CreateResourceTypeSegmentsDto segmentations,
            Long defaultQuota,
            Boolean virtual,
            FeatureStateInputDto allocatedSupported,
            @Nullable AggregationSettingsInputDto aggregationSettings
    ) {
        this.key = key;
        this.unitsEnsembleId = unitsEnsembleId;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.readOnly = readOnly;
        this.orderable = orderable;
        this.managed = managed;
        this.allowedUnitIds = allowedUnitIds;
        this.defaultUnitId = defaultUnitId;
        this.providerApiUnitId = providerApiUnitId;
        this.segmentations = segmentations;
        this.defaultQuota = defaultQuota;
        this.virtual = virtual;
        this.allocatedSupported = allocatedSupported;
        this.aggregationSettings = aggregationSettings;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Units ensemble id.", required = true)
    public Optional<String> getUnitsEnsembleId() {
        return Optional.ofNullable(unitsEnsembleId);
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "'Read only' flag.", required = true)
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    @Schema(description = "'Resource can be ordered' flag.", required = true)
    public Optional<Boolean> getOrderable() {
        return Optional.ofNullable(orderable);
    }

    @Schema(description = "'Managed' flag.", required = true)
    public Optional<Boolean> getManaged() {
        return Optional.ofNullable(managed);
    }

    @Schema(description = "Allowed unit ids.", required = true)
    public Optional<List<String>> getAllowedUnitIds() {
        return Optional.ofNullable(allowedUnitIds);
    }

    @Schema(description = "Default unit id.", required = true)
    public Optional<String> getDefaultUnitId() {
        return Optional.ofNullable(defaultUnitId);
    }

    @Schema(description = "Unit id, used to interact with provider.")
    public Optional<String> getProviderApiUnitId() {
        return Optional.ofNullable(providerApiUnitId);
    }

    @Schema(description = "Resource type and segments.")
    public Optional<CreateResourceTypeSegmentsDto> getSegmentations() {
        return Optional.ofNullable(segmentations);
    }

    @Schema(description = "Default free quota, provided for this resource automatically.")
    public Optional<Long> getDefaultQuota() {
        return Optional.ofNullable(defaultQuota);
    }

    @Schema(description = "'Virtual' flag.")
    public Optional<Boolean> getVirtual() {
        return Optional.ofNullable(virtual);
    }

    @Schema(description = "'Allocated supported' feature state.")
    public Optional<FeatureStateInputDto> getAllocatedSupported() {
        return Optional.ofNullable(allocatedSupported);
    }

    @Schema(description = "Aggregation settings.")
    public Optional<AggregationSettingsInputDto> getAggregationSettings() {
        return Optional.ofNullable(aggregationSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceCreateDto that = (ResourceCreateDto) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(unitsEnsembleId, that.unitsEnsembleId) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(readOnly, that.readOnly) &&
                Objects.equals(orderable, that.orderable) &&
                Objects.equals(managed, that.managed) &&
                Objects.equals(allowedUnitIds, that.allowedUnitIds) &&
                Objects.equals(defaultUnitId, that.defaultUnitId) &&
                Objects.equals(segmentations, that.segmentations) &&
                Objects.equals(defaultQuota, that.defaultQuota) &&
                Objects.equals(providerApiUnitId, that.providerApiUnitId) &&
                Objects.equals(virtual, that.virtual) &&
                Objects.equals(allocatedSupported, that.allocatedSupported) &&
                Objects.equals(aggregationSettings, that.aggregationSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, unitsEnsembleId, nameEn, nameRu, descriptionEn, descriptionRu, readOnly, virtual,
                orderable, managed, allowedUnitIds, defaultUnitId, segmentations, defaultQuota, providerApiUnitId,
                allocatedSupported, aggregationSettings);
    }

    @Override
    public String toString() {
        return "ResourceCreateDto{" +
                "key='" + key + '\'' +
                ", unitsEnsembleId='" + unitsEnsembleId + '\'' +
                ", nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", readOnly=" + readOnly +
                ", orderable=" + orderable +
                ", managed=" + managed +
                ", allowedUnitIds=" + allowedUnitIds +
                ", defaultUnitId='" + defaultUnitId + '\'' +
                ", providerApiUnitId='" + providerApiUnitId + '\'' +
                ", segmentations=" + segmentations +
                ", defaultQuota=" + defaultQuota +
                ", virtual=" + virtual +
                ", allocatedSupported=" + allocatedSupported +
                ", aggregationSettings=" + aggregationSettings +
                '}';
    }
}
