package ru.yandex.intranet.d.web.model.resources.directory;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.FeatureStateDto;
import ru.yandex.intranet.d.web.model.providers.AggregationSettingsDto;

/**
 * Resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceDto {

    private final String id;
    private final String key;
    private final String providerId;
    private final String unitsEnsembleId;
    private final long version;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final boolean readOnly;
    private final boolean orderable;
    private final boolean managed;
    private final Set<String> allowedUnitIds;
    private final String defaultUnitId;
    private final String providerApiUnitId;
    private final InnerResourceTypeSegmentsDto segmentations;
    private final Long defaultQuota;
    private final boolean virtual;
    private final FeatureStateDto allocatedSupported;
    private final @Nullable AggregationSettingsDto aggregationSettings;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ResourceDto(
            String id,
            String key,
            String providerId,
            String unitsEnsembleId,
            long version,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            boolean readOnly,
            boolean orderable,
            boolean managed,
            Set<String> allowedUnitIds,
            String defaultUnitId,
            String providerApiUnitId,
            InnerResourceTypeSegmentsDto segmentations,
            Long defaultQuota,
            boolean virtual,
            FeatureStateDto allocatedSupported,
            @Nullable AggregationSettingsDto aggregationSettings
    ) {
        this.id = id;
        this.key = key;
        this.providerId = providerId;
        this.unitsEnsembleId = unitsEnsembleId;
        this.version = version;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.readOnly = readOnly;
        this.orderable = orderable;
        this.managed = managed;
        this.allowedUnitIds = allowedUnitIds;
        this.defaultUnitId = defaultUnitId;
        this.providerApiUnitId = providerApiUnitId;
        this.segmentations = segmentations;
        this.defaultQuota = defaultQuota;
        this.virtual = virtual;
        this.allocatedSupported = allocatedSupported;
        this.aggregationSettings = aggregationSettings;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Units ensemble id.", required = true)
    public String getUnitsEnsembleId() {
        return unitsEnsembleId;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name, english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "'Resource can be ordered' flag.", required = true)
    public boolean isOrderable() {
        return orderable;
    }

    @Schema(description = "'Managed' flag.", required = true)
    public boolean isManaged() {
        return managed;
    }

    @Schema(description = "Allowed unit ids.", required = true)
    public Set<String> getAllowedUnitIds() {
        return allowedUnitIds;
    }

    @Schema(description = "Default unit id.", required = true)
    public String getDefaultUnitId() {
        return defaultUnitId;
    }

    @Schema(description = "Unit id, used to interact with provider.")
    public String getProviderApiUnitId() {
        return providerApiUnitId;
    }

    @Schema(description = "Resource type and segments.")
    public Optional<InnerResourceTypeSegmentsDto> getSegmentations() {
        return Optional.ofNullable(segmentations);
    }

    @Schema(description = "Default free quota, provided for this resource automatically.")
    public Long getDefaultQuota() {
        return defaultQuota;
    }

    @Schema(description = "'Virtual' flag.", required = true)
    public boolean isVirtual() {
        return virtual;
    }

    @Schema(description = "'Allocated supported' feature state.", required = true)
    public FeatureStateDto getAllocatedSupported() {
        return allocatedSupported;
    }

    @Schema(description = "Aggregation settings.")
    public Optional<AggregationSettingsDto> getAggregationSettings() {
        return Optional.ofNullable(aggregationSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceDto that = (ResourceDto) o;
        return version == that.version &&
                readOnly == that.readOnly &&
                orderable == that.orderable &&
                managed == that.managed &&
                virtual == that.virtual &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(unitsEnsembleId, that.unitsEnsembleId) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(allowedUnitIds, that.allowedUnitIds) &&
                Objects.equals(defaultUnitId, that.defaultUnitId) &&
                Objects.equals(segmentations, that.segmentations) &&
                Objects.equals(defaultQuota, that.defaultQuota) &&
                Objects.equals(providerApiUnitId, that.providerApiUnitId) &&
                Objects.equals(allocatedSupported, that.allocatedSupported) &&
                Objects.equals(aggregationSettings, that.aggregationSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, providerId, unitsEnsembleId, version, nameEn, nameRu, descriptionEn,
                descriptionRu, readOnly, orderable, managed, allowedUnitIds, defaultUnitId, segmentations,
                defaultQuota, providerApiUnitId, virtual, allocatedSupported, aggregationSettings);
    }

    @Override
    public String toString() {
        return "ResourceDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", providerId='" + providerId + '\'' +
                ", unitsEnsembleId='" + unitsEnsembleId + '\'' +
                ", version=" + version +
                ", nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", readOnly=" + readOnly +
                ", orderable=" + orderable +
                ", managed=" + managed +
                ", allowedUnitIds=" + allowedUnitIds +
                ", defaultUnitId='" + defaultUnitId + '\'' +
                ", providerApiUnitId='" + providerApiUnitId + '\'' +
                ", segmentations=" + segmentations +
                ", defaultQuota=" + defaultQuota +
                ", virtual=" + virtual +
                ", allocatedSupported=" + allocatedSupported +
                ", aggregationSettings=" + aggregationSettings +
                '}';
    }
}
