package ru.yandex.intranet.d.web.model.resources.directory.segmentations;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Create resource segmentation DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceSegmentationCreateDto {

    private final String key;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final Integer groupingOrder;
    private final SegmentationUISettingsDto uiSettings;

    @JsonCreator
    public ResourceSegmentationCreateDto(
            String key,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            Integer groupingOrder,
            SegmentationUISettingsDto uiSettings
    ) {
        this.key = key;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.groupingOrder = groupingOrder;
        this.uiSettings = uiSettings;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "Order position for grouping and collecting quotas sums.")
    public Optional<Integer> getGroupingOrder() {
        return Optional.ofNullable(groupingOrder);
    }

    @Schema(description = "UI Settings.")
    public Optional<SegmentationUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSegmentationCreateDto that = (ResourceSegmentationCreateDto) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(groupingOrder, that.groupingOrder) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, nameEn, nameRu, descriptionEn, descriptionRu, groupingOrder,
                uiSettings);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
