package ru.yandex.intranet.d.web.model.resources.directory.segmentations;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Resource segmentation DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceSegmentationDto {

    private final String id;
    private final String providerId;
    private final long version;
    private final String key;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final int groupingOrder;
    private final SegmentationUISettingsDto uiSettings;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ResourceSegmentationDto(
            String id,
            String providerId,
            long version,
            String key,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            int groupingOrder,
            SegmentationUISettingsDto uiSettings
    ) {
        this.id = id;
        this.providerId = providerId;
        this.version = version;
        this.key = key;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.groupingOrder = groupingOrder;
        this.uiSettings = uiSettings;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name, english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "Order position for grouping and collecting quotas sums.")
    public int getGroupingOrder() {
        return groupingOrder;
    }

    @Schema(description = "UI Settings.")
    public SegmentationUISettingsDto getUiSettings() {
        return uiSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSegmentationDto that = (ResourceSegmentationDto) o;
        return version == that.version &&
                groupingOrder == that.groupingOrder &&
                Objects.equals(id, that.id) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, providerId, version, key, nameEn, nameRu, descriptionEn, descriptionRu, groupingOrder,
                uiSettings);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
