package ru.yandex.intranet.d.web.model.resources.directory.segmentations;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Put resource segmentation DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segmentation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceSegmentationPutDto {

    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final Integer groupingOrder;
    private final SegmentationUISettingsDto uiSettings;

    @JsonCreator
    public ResourceSegmentationPutDto(
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            Integer groupingOrder,
            SegmentationUISettingsDto uiSettings
    ) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.groupingOrder = groupingOrder;
        this.uiSettings = uiSettings;
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "Order position for grouping and collecting quotas sums.")
    public Optional<Integer> getGroupingOrder() {
        return Optional.ofNullable(groupingOrder);
    }

    @Schema(description = "UI Settings.")
    public Optional<SegmentationUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSegmentationPutDto that = (ResourceSegmentationPutDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(groupingOrder, that.groupingOrder) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, groupingOrder, uiSettings);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

}
