package ru.yandex.intranet.d.web.model.resources.directory.segmentations

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.resources.segmentations.SegmentationUISettings
import ru.yandex.intranet.d.web.model.MultilingualGrammaticalFormsDto

/**
 * SegmentationUISettingsDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 05-03-2022
 */
@Schema(description = "Segmentation UI settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
data class SegmentationUISettingsDto(
    @get:[Schema(description = "Segmentation position in choice order.")]
    val choiceOrder: Int?,

    @get:[Schema(description = "Flag for placing segmentation choice in same block with previous.")]
    val inSameBlockWithPrevious: Boolean?,

    @get:[Schema(description = "Segmentation title forms.")]
    val title: MultilingualGrammaticalFormsDto?,
) {
    constructor(model: SegmentationUISettings) : this(
        choiceOrder = model.choiceOrder,
        inSameBlockWithPrevious = model.inSameBlockWithPrevious,
        title = model.title?.let { MultilingualGrammaticalFormsDto(it) },
    )

    constructor(proto: ru.yandex.intranet.d.backend.service.proto.SegmentationUISettings) : this(
        choiceOrder = proto.choiceOrder,
        inSameBlockWithPrevious = proto.inSameBlockWithPrevious,
        title = proto.title?.let { MultilingualGrammaticalFormsDto(it) },
    )

    @JsonIgnore
    fun toModel(): SegmentationUISettings {
        return SegmentationUISettings(
            choiceOrder = choiceOrder,
            inSameBlockWithPrevious = inSameBlockWithPrevious,
            title = title?.toModel(),
        )
    }
}
