package ru.yandex.intranet.d.web.model.resources.directory.segments;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Resource segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceSegmentDto {

    private final String id;
    private final String segmentationId;
    private final long version;
    private final String key;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final boolean uncommon;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ResourceSegmentDto(@JsonProperty("id") String id,
                              @JsonProperty("segmentationId") String segmentationId,
                              @JsonProperty("version") long version,
                              @JsonProperty("key") String key,
                              @JsonProperty("nameEn") String nameEn,
                              @JsonProperty("nameRu") String nameRu,
                              @JsonProperty("descriptionEn") String descriptionEn,
                              @JsonProperty("descriptionRu") String descriptionRu,
                              @JsonProperty("uncommon") boolean uncommon) {
        this.id = id;
        this.segmentationId = segmentationId;
        this.version = version;
        this.key = key;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.uncommon = uncommon;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Segmentation id.", required = true)
    public String getSegmentationId() {
        return segmentationId;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Key, unique per segmentation.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Name, english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "'Uncommon' flag.", required = true)
    public boolean getUncommon() {
        return uncommon;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSegmentDto that = (ResourceSegmentDto) o;
        return version == that.version &&
                uncommon == that.uncommon &&
                Objects.equals(id, that.id) &&
                Objects.equals(segmentationId, that.segmentationId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, segmentationId, version, key, nameEn, nameRu, descriptionEn, descriptionRu, uncommon);
    }

    @Override
    public String toString() {
        return "ResourceSegmentDto{" +
                "id='" + id + '\'' +
                ", segmentationId='" + segmentationId + '\'' +
                ", version=" + version +
                ", key='" + key + '\'' +
                ", nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", uncommon=" + uncommon +
                '}';
    }

}
