package ru.yandex.intranet.d.web.model.resources.directory.segments;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put resource segment DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Resource segment.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceSegmentPutDto {

    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final Boolean uncommon;

    @JsonCreator
    public ResourceSegmentPutDto(@JsonProperty("nameEn") String nameEn,
                                 @JsonProperty("nameRu") String nameRu,
                                 @JsonProperty("descriptionEn") String descriptionEn,
                                 @JsonProperty("descriptionRu") String descriptionRu,
                                 @JsonProperty("uncommon") Boolean uncommon) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.uncommon = uncommon;
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "'Uncommon' flag.")
    public Optional<Boolean> getUncommon() {
        return Optional.ofNullable(uncommon);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSegmentPutDto that = (ResourceSegmentPutDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(uncommon, that.uncommon);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, uncommon);
    }

    @Override
    public String toString() {
        return "ResourceSegmentPutDto{" +
                "nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", uncommon=" + uncommon +
                '}';
    }

}
