package ru.yandex.intranet.d.web.model.resources.directory.spaces;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.providers.ProviderUISettingsDto;
import ru.yandex.intranet.d.web.model.resources.directory.CreateResourceSegmentationSegmentDto;

/**
 * AccountsSpaceCreateDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @see ru.yandex.intranet.d.backend.service.proto.NewAccountsSpace
 * @since 03.02.2021
 */
@Schema(description = "Accounts space.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpaceCreateDto {
    private final String key;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final boolean readOnly;
    private final List<CreateResourceSegmentationSegmentDto> segments;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final boolean syncEnabled;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public AccountsSpaceCreateDto(
            String key,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            boolean readOnly,
            List<CreateResourceSegmentationSegmentDto> segments,
            @Nullable ProviderUISettingsDto uiSettings,
            boolean syncEnabled
    ) {
        this.key = key;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.readOnly = readOnly;
        this.segments = segments;
        this.uiSettings = uiSettings;
        this.syncEnabled = syncEnabled;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "Segments.", required = true)
    public List<CreateResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "Sync with provider flag.", required = true)
    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpaceCreateDto that = (AccountsSpaceCreateDto) o;
        return readOnly == that.readOnly &&
                syncEnabled == that.syncEnabled &&
                Objects.equals(key, that.key) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, nameEn, nameRu, descriptionEn, descriptionRu, readOnly, segments, uiSettings,
                syncEnabled);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
