package ru.yandex.intranet.d.web.model.resources.directory.spaces;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.providers.ProviderUISettingsDto;
import ru.yandex.intranet.d.web.model.resources.directory.InnerResourceSegmentationSegmentDto;

/**
 * AccountsSpaceDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @see ru.yandex.intranet.d.backend.service.proto.FullAccountsSpace
 * @since 26.01.2021
 */
@Schema(description = "Accounts space.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpaceDto {
    private final String id;
    private final String key;
    private final String providerId;
    private final long version;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final boolean readOnly;
    private final Set<InnerResourceSegmentationSegmentDto> segments;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final boolean syncEnabled;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public AccountsSpaceDto(
            String id,
            String key,
            String providerId,
            long version,
            String nameEn,
            String nameRu,
            String descriptionEn,
            String descriptionRu,
            boolean readOnly,
            Set<InnerResourceSegmentationSegmentDto> segments,
            @Nullable ProviderUISettingsDto uiSettings,
            boolean syncEnabled
    ) {
        this.id = id;
        this.key = key;
        this.providerId = providerId;
        this.version = version;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.readOnly = readOnly;
        this.segments = segments;
        this.uiSettings = uiSettings;
        this.syncEnabled = syncEnabled;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Key, unique per provider.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name, english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "Segments.", required = true)
    public Set<InnerResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "Sync with provider flag.", required = true)
    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpaceDto that = (AccountsSpaceDto) o;
        return version == that.version &&
                readOnly == that.readOnly &&
                syncEnabled == that.syncEnabled &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, providerId, version, nameEn, nameRu, descriptionEn, descriptionRu, readOnly,
                segments, uiSettings, syncEnabled);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
