package ru.yandex.intranet.d.web.model.resources.directory.spaces;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.providers.ProviderUISettingsDto;

/**
 * AccountsSpacePutDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @see ru.yandex.intranet.d.backend.service.proto.UpdatedAccountsSpace
 * @since 03.02.2021
 */
@Schema(description = "Accounts space.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsSpacePutDto {
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final boolean syncEnabled;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public AccountsSpacePutDto(String nameEn, String nameRu, String descriptionEn, String descriptionRu,
                               @Nullable ProviderUISettingsDto uiSettings, boolean syncEnabled) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.uiSettings = uiSettings;
        this.syncEnabled = syncEnabled;
    }

    @Schema(description = "Name, english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name, russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description, english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description, russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "Sync with provider flag.", required = true)
    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsSpacePutDto that = (AccountsSpacePutDto) o;
        return syncEnabled == that.syncEnabled &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, uiSettings, syncEnabled);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
