package ru.yandex.intranet.d.web.model.resources.directory.types;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.PatchedValue;
import ru.yandex.intranet.d.web.model.providers.AggregationSettingsInputDto;

/**
 * Patch resource type DTO.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Resource type.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceTypePatchDto {

    private final PatchedValue<String> nameEn;
    private final PatchedValue<String> nameRu;
    private final PatchedValue<String> descriptionEn;
    private final PatchedValue<String> descriptionRu;
    private final PatchedValue<Long> sortingOrder;
    private final PatchedValue<AggregationSettingsInputDto> aggregationSettings;

    public ResourceTypePatchDto(PatchedValue<String> nameEn,
                                PatchedValue<String> nameRu,
                                PatchedValue<String> descriptionEn,
                                PatchedValue<String> descriptionRu,
                                PatchedValue<Long> sortingOrder,
                                PatchedValue<AggregationSettingsInputDto> aggregationSettings) {
        this.nameEn = nameEn == null ? PatchedValue.noChanged() : nameEn;
        this.nameRu = nameRu == null ? PatchedValue.noChanged() : nameRu;
        this.descriptionEn = descriptionEn == null ? PatchedValue.noChanged() : descriptionEn;
        this.descriptionRu = descriptionRu == null ? PatchedValue.noChanged() : descriptionRu;
        this.sortingOrder = sortingOrder == null ? PatchedValue.noChanged() : sortingOrder;
        this.aggregationSettings = aggregationSettings == null ? PatchedValue.noChanged() : aggregationSettings;
    }

    @Schema(description = "Name, english.", implementation = String.class)
    public PatchedValue<String> getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name, russian.", implementation = String.class)
    public PatchedValue<String> getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description, english.", implementation = String.class)
    public PatchedValue<String> getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description, russian.", implementation = String.class)
    public PatchedValue<String> getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "Sorting order.", implementation = Long.class)
    public PatchedValue<Long> getSortingOrder() {
        return sortingOrder;
    }

    @Schema(description = "Aggregation settings.", implementation = AggregationSettingsInputDto.class)
    public PatchedValue<AggregationSettingsInputDto> getAggregationSettings() {
        return aggregationSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceTypePatchDto that = (ResourceTypePatchDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(sortingOrder, that.sortingOrder) &&
                Objects.equals(aggregationSettings, that.aggregationSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, sortingOrder, aggregationSettings);
    }

    @Override
    public String toString() {
        return "ResourceTypePutDto{" +
                "nameEn='" + nameEn + '\'' +
                ", nameRu='" + nameRu + '\'' +
                ", descriptionEn='" + descriptionEn + '\'' +
                ", descriptionRu='" + descriptionRu + '\'' +
                ", sortingOrder=" + sortingOrder +
                ", aggregationSettings=" + aggregationSettings +
                '}';
    }

}
