package ru.yandex.intranet.d.web.model.resources.exchangeable

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.model.resources.types.ExchangeableResourceTypeModel

@Schema(description = "Pair of exchangeable resource types")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontExchangeableResourceTypesDto @JsonCreator constructor(
    @get:Schema(description = "Resource type that user gives out", required = true)
    val fromResourceTypeId: ResourceTypeId,
    @get:Schema(description = "Resource type that user receives", required = true)
    val toResourceTypeId: ResourceTypeId,
    @get:Schema(description = "Segments in which exchange is available", required = true)
    val segments: Set<SegmentationAndSegmentsIdsDto>,
    @get:Schema(description = "Numerator. In exchange 1:2, numerator = 1.", required = true)
    val numerator: Long,
    @get:Schema(description = "Denominator. In exchange 1:2, denominator = 2.", required = true)
    val denominator: Long
) {
    constructor(model: ExchangeableResourceTypeModel) : this(
        fromResourceTypeId = model.key.fromResourceTypeId,
        toResourceTypeId = model.key.toResourceTypeId,
        segments = model.available_segments.segments.map { (segmentation, segments) ->
            SegmentationAndSegmentsIdsDto(segmentation, segments)
        }.toSet(),
        numerator = model.numerator,
        denominator = model.denominator
    )
}

@Schema(description = "Allowed segmentation and segments` ids.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class SegmentationAndSegmentsIdsDto(
    @get:Schema(description = "Segmentation id.", required = true)
    val segmentationId: SegmentationId,
    @get:Schema(description = "Allowed segments` ids in the segmentation.", required = true)
    val segmentIds: Set<SegmentId>
)
