package ru.yandex.intranet.d.web.model.services;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * List of ABC service ids to check closing
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "List of ABC service ids to check closing.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class CheckServicesRequestDto {

    private final List<Long> serviceIds;

    @JsonCreator
    public CheckServicesRequestDto(List<Long> serviceIds) {
        this.serviceIds = serviceIds;
    }

    @Schema(description = "List of ABC service ids", required = true)
    public List<Long> getServiceIds() {
        return serviceIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckServicesRequestDto that = (CheckServicesRequestDto) o;
        return Objects.equals(serviceIds, that.serviceIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceIds);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
