package ru.yandex.intranet.d.web.model.services;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * List of ABC services with closing flags
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "List of ABC services with closing flag.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ClosingServiceDto {

    private final List<ValueByServiceIdDto> closing;

    @JsonCreator
    public ClosingServiceDto(List<ValueByServiceIdDto> closing) {
        this.closing = closing;
    }

    @Schema(description = "List of ABC services", required = true)
    public List<ValueByServiceIdDto> getClosing() {
        return closing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClosingServiceDto that = (ClosingServiceDto) o;
        return Objects.equals(closing, that.closing);
    }

    @Override
    public int hashCode() {
        return Objects.hash(closing);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
