package ru.yandex.intranet.d.web.model.services

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.services.ServiceReadOnlyState
import ru.yandex.intranet.d.model.services.ServiceState

@Schema(description = "Service minimal DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ServiceMinimalDto @JsonCreator constructor(
    @get:Schema(description = "Service id")
    val id: Long,
    @get:Schema(description = "Localized service name")
    val name: String,
    @get:Schema(description = "Service slug")
    val slug: String,
    @get:Schema(description = "Service state")
    val state: ServiceState,
    @get:Schema(description = "Read only state")
    val readOnlyState: ServiceReadOnlyState,
    @get:Schema(description = "Is exportable")
    val exportable: Boolean
)
