package ru.yandex.intranet.d.web.model.services;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Service with value DTO
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Service with value.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ValueByServiceIdDto {

    private final long serviceId;
    private final boolean value;

    @JsonCreator
    public ValueByServiceIdDto(long serviceId, boolean value) {
        this.serviceId = serviceId;
        this.value = value;
    }

    @Schema(description = "Service id.", required = true)
    public long getServiceId() {
        return serviceId;
    }

    @Schema(description = "Value.", required = true)
    public boolean isValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValueByServiceIdDto that = (ValueByServiceIdDto) o;
        return serviceId == that.serviceId && value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, value);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
