package ru.yandex.intranet.d.web.model.settings

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Known providers.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Known providers.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class KnownProvidersDto @JsonCreator constructor(
    @get:Schema(description = "YT provider id.")
    val yt: String?,
    @get:Schema(description = "YP provider id.")
    val yp: String?,
    @get:Schema(description = "YP pre-stable provider id.")
    val ypPreStable: String?,
)
